/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.handlers;

import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.util.RsfHexadecimal;
import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.rcs.conndata.AccountInfo;
import com.ibm.hwmca.fw.rcs.sas.SasTransactionException;
import com.ibm.hwmca.fw.rcs.sas.SasXmlException;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rcs.sas.SystemAuthentication;
import com.ibm.hwmca.fw.rcs.sas.SystemAuthenticationException;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;

public class RetainUtils
implements BaseRsfHandlersErrorIds {
    private static String TRACE_MASKF = "XSSIQS F";
    private static String TRACE_MASKT = "XSSIQS T";
    private static String TRACE_MASKD = "XSSIQS D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "RetainUtils");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private static FrameworkLogAttributes infoLogDisplayError = new FrameworkLogAttributes(false, false, true, true, true, true, false, 0);
    private static String saDialUserPwd = "URSF/FURUS    URSFTST 0924-5575        ";
    private static String dialUserPwd = "URSF/PURUS    URSFTST 0924-5575        ";
    private static String vpnUserPwd = "URSF/VUS  MTMTMSMSMSMSM ";
    private static String saDialPrefix = "URSF/F";
    private static String dialPrefix = "URSF/P";
    private static String dialSuffix = "0000-0000        ";
    private static String saVpnPrefix = "URSF/N";
    private static String vpnPrefix = "URSF/V";
    private static String vpnSuffix = "                 ";
    private static String saVpnUserPwd = "URSF/NUS  MTMTMSMSMSMSM                 ";
    public static final int ZSERIES_PAP = 0;
    public static final int ISERIES_PAP = 1;
    public static final int STORDIR_PAP = 2;
    public static final int STORAGE_PAP = 3;
    public static final int SUCCESS = 0;
    public static final int FAILURE = 99;
    public static final int PERMANENT_FAILURE = 999;
    public static int VALID_SYSID_LENGTH = 8;
    static String[] papIds = new String[]{"END5", "ROCS", "BOL1", "END4"};
    static File tempPath;
    static Object lock;
    public static int defaultTimeout;
    private static String EBCDIC;
    private static final int receiveTries = 60;
    private static final int receiveWait = 1000;
    private static final int MAX_TOKEN_RETRIES = 3;
    private static final int retryWait = 1000;
    private static final int longerRetryWait = 60000;
    private static boolean oneTest;
    private static byte[] endBytes;
    private static byte[] lcEndBytes;

    public static byte[] getLoginInfo(int papId, XFrameRsfRequestBody rsfContent, String token) throws IllegalArgumentException {
        int i;
        byte[] login;
        Trace.trace(TRACE_MASKT, "-> RetainUtils::getLoginInfo()");
        if (papId > papIds.length) {
            Trace.trace(TRACE_MASKF, "RetainUtils:: getLoginInfo: Invalid papId=" + papId);
            throw new IllegalArgumentException("Invalid papId for login info");
        }
        if (rsfContent == null) {
            throw new IllegalArgumentException("XFrameRsfRequestBody is null");
        }
        String machType = rsfContent.getReportingMachineInfo().getMachineType();
        String machSerial = rsfContent.getReportingMachineInfo().getMachineSerial();
        if (machType == null || machSerial == null) {
            throw new IllegalArgumentException("Machine type or machine serial is null");
        }
        Trace.trace(TRACE_MASKD, "RetainUtils.getLoginInfo(): Got machine serial=" + machSerial + " machine type=" + machType);
        if (machType.length() < 4) {
            Trace.trace(TRACE_MASKF, "RetainUtils.getLoginInfo(): Invalid machine type=" + machType);
            throw new IllegalArgumentException("Login info - Illegal machine type:" + machType);
        }
        if (machSerial.length() < 7) {
            Trace.trace(TRACE_MASKF, "RetainUtils.getLoginInfo(): Invalid machine type=" + machType);
            throw new IllegalArgumentException("Login info - Illegal machine type:" + machType);
        }
        if (!oneTest && BaseRemoteSupportFacility.testFlag.equals("BAD_MTMS")) {
            machSerial = "GARBAGE";
            oneTest = true;
        }
        if (token != null) {
            int tokenLength = token.length();
            int totLength = 31 + tokenLength;
            login = new byte[totLength];
            byte[] lengthField = RetainUtils.calcLength(totLength - 2);
            login[0] = lengthField[0];
            login[1] = lengthField[1];
            login[7] = 3;
            login[17] = 11;
            login[27] = 0;
            login[28] = 0;
            byte[] tokenLengthField = RetainUtils.calcLength(tokenLength - 2);
            login[29] = tokenLengthField[0];
            login[30] = tokenLengthField[1];
            try {
                byte[] tokenBytes = token.getBytes(EBCDIC);
                i = 0;
                while (i < tokenBytes.length) {
                    login[31 + i] = tokenBytes[i];
                    ++i;
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "RetainUtils.getLoginInfo() Unsupported Encoding exception");
                Trace.trace(TRACE_MASKF, e);
            }
        } else {
            login = new byte[27];
            login[0] = 0;
            login[1] = 27;
            login[7] = 2;
            login[17] = 0;
        }
        try {
            login[6] = 0;
            byte[] papBytes = papIds[papId].getBytes(EBCDIC);
            login[8] = 0;
            login[9] = 8;
            login[10] = 0;
            login[11] = 4;
            login[16] = 0;
            login[18] = 0;
            login[19] = 7;
            int i2 = 0;
            while (i2 < 4) {
                login[i2 + 2] = papBytes[i2];
                ++i2;
            }
            byte[] mType = machType.getBytes(EBCDIC);
            int i3 = 0;
            while (i3 < 4) {
                login[i3 + 12] = mType[i3];
                ++i3;
            }
            String serial = machSerial;
            if (machSerial.length() >= 12) {
                serial = machSerial.substring(3, 5) + machSerial.substring(7, 12);
            }
            byte[] mSerial = serial.getBytes(EBCDIC);
            i = 0;
            while (i < 7) {
                login[i + 20] = mSerial[i];
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            Trace.trace(TRACE_MASKF, "RetainUtils: Unsupported encoding exception:" + EBCDIC);
            new FrameworkLog(logInfo, 28671, e).log(infoLog);
        }
        Trace.trace(TRACE_MASKT, "<- RetainUtils::getLoginInfo()");
        return login;
    }

    public static String getRetainToken(BaseRsfRequestImpl request, BaseRsfResultDetails details) throws IOException, HException {
        Trace.trace(TRACE_MASKT, "-> RetainUtils::getRetainToken()");
        SysInfo owningCredentials = request.getOwningCredentials();
        if (owningCredentials == null) {
            return null;
        }
        if (!oneTest && BaseRemoteSupportFacility.testFlag.equals("BAD_CREDENTIAL_ID")) {
            Trace.trace(TRACE_MASKF, " RetainUtils::getRetainToken() testcase bad credential machine id");
            owningCredentials = new SysInfo("GARBAGE", owningCredentials.getPassword());
            oneTest = true;
        } else if (!oneTest && BaseRemoteSupportFacility.testFlag.equals("BAD_CREDENTIAL_PASSWORD")) {
            Trace.trace(TRACE_MASKF, " RetainUtils::getRetainToken() testcase bad credential password");
            owningCredentials = new SysInfo(owningCredentials.getMachineId(), "GARBAGE");
            oneTest = true;
        }
        int sysidLength = owningCredentials.getMachineId().length();
        if (sysidLength != VALID_SYSID_LENGTH) {
            String msg = "RetainUtils getRetainToken found owning system id '" + owningCredentials.getMachineId() + "' with length " + sysidLength + ".  Should be " + VALID_SYSID_LENGTH + ".";
            HException exc = new HException(msg);
            RetainUtils.logErrorAndResult(details, msg, exc, (short)28480, 13);
            throw exc;
        }
        SysInfo sendingCredentials = null;
        try {
            sendingCredentials = CredentialUtils.getLocalCredentials();
        }
        catch (Exception e) {
            HException exc = new HException(e);
            RetainUtils.logErrorAndResult(details, "RetainUtils: getRetainToken: Exception getting local HMC credentials", exc, (short)28671, 7);
            throw exc;
        }
        if (sendingCredentials == null) {
            HException exc = new HException("RetainUtils getRetainToken found null local credentials");
            RetainUtils.logErrorAndResult(details, "RetainUtils: getRetainToken: No local HMC credentials", exc, (short)28671, 7);
            throw exc;
        }
        sysidLength = sendingCredentials.getMachineId().length();
        if (sysidLength != VALID_SYSID_LENGTH) {
            String msg = "RetainUtils getRetainToken found sending system id '" + sendingCredentials.getMachineId() + "' with length " + sysidLength + ".  Should be " + VALID_SYSID_LENGTH + ".";
            HException exc = new HException(msg);
            RetainUtils.logErrorAndResult(details, msg, exc, (short)28480, 14);
            throw exc;
        }
        TcpConnection tcpConnection = new TcpConnection(3);
        String token = null;
        boolean done = false;
        int retryCount = 0;
        String lastRc = null;
        details.setErrLogMsg(null);
        details.getRsfResultDetails().putAttribute("SAS rc", null);
        boolean retry = false;
        while (!done) {
            retry = false;
            if (retryCount > 3) {
                if (!tcpConnection.failSocket()) {
                    details.setErrLogMsg("GetToken returned error rc=" + lastRc + " after " + retryCount + " getToken() attempts.");
                    details.getRsfResultDetails().putAttribute("SAS rc", lastRc);
                    break;
                }
                retryCount = 0;
            }
            try {
                ++retryCount;
                token = SystemAuthentication.getToken(tcpConnection, sendingCredentials, owningCredentials);
                done = true;
            }
            catch (SasTransactionException e) {
                lastRc = e.getMessage();
                String message = "RetainUtils.getRetainToken: rc from getToken=" + lastRc;
                String callerMessage = "Get token for strong authentication returned an error rc=" + lastRc;
                if (lastRc.equals("2000")) {
                    RetainUtils.retryWait(retryCount, message);
                    continue;
                }
                if (lastRc.equals("2100")) {
                    RetainUtils.retryWait(retryCount, message);
                    retry = true;
                    continue;
                }
                if (lastRc.equals("3000")) {
                    RetainUtils.retryLongWait(retryCount, message);
                    retry = true;
                    continue;
                }
                if (lastRc.equals("5000")) {
                    RetainUtils.logErrorAndResult(details, message, null, (short)28480, 12);
                    details.setErrLogMsg(callerMessage);
                    details.getRsfResultDetails().putAttribute("SAS rc", lastRc);
                    return null;
                }
                if (lastRc.equals("6000")) {
                    RetainUtils.logErrorAndResult(details, message, null, (short)28480, 12);
                    details.setErrLogMsg(callerMessage);
                    details.getRsfResultDetails().putAttribute("SAS rc", lastRc);
                    return null;
                }
                if (lastRc.equals("7000")) {
                    RetainUtils.logError(message + ". Will redrive on new connection or HMC.", null, (short)28480);
                    details.setReasonCode(10);
                    retryCount = 4;
                    continue;
                }
                if (lastRc.equals("7100")) {
                    RetainUtils.logErrorAndResult(details, message + ". Owning system credential failure.", null, (short)28480, 13);
                    details.setErrLogMsg(callerMessage + ". This indicates an unknown owning system identifier or invalid password.");
                    details.getRsfResultDetails().putAttribute("SAS rc", lastRc);
                    return null;
                }
                if (lastRc.equals("7101")) {
                    CredentialUtils.clearLocalCredentials();
                    RetainUtils.logErrorAndResult(details, message + ". Sending system credential failure. Local credential cleared.  Will retry", null, (short)28480, 14);
                    details.setErrLogMsg(callerMessage + ". This indicates an unknown sending system identifier or invalid password.");
                    details.getRsfResultDetails().putAttribute("SAS rc", lastRc);
                    return null;
                }
                if (lastRc.equals("7150")) {
                    RetainUtils.logErrorAndResult(details, message + ". Owning system credential failure.", null, (short)28480, 13);
                    details.setErrLogMsg(callerMessage + ". This indicates the owning system has temporarily been denied access to the data receiver.");
                    details.getRsfResultDetails().putAttribute("SAS rc", lastRc);
                    return null;
                }
                if (lastRc.equals("7151")) {
                    CredentialUtils.clearLocalCredentials();
                    RetainUtils.logErrorAndResult(details, message + ". Sending system credential failure.  Local credential cleared.  Will retry", null, (short)28480, 14);
                    details.setErrLogMsg(callerMessage + ". This indicates the sending system has temporarily been denied access to the data receiver.");
                    details.getRsfResultDetails().putAttribute("SAS rc", lastRc);
                    return null;
                }
                if (lastRc.equals("7180")) {
                    RetainUtils.logErrorAndResult(details, message + ". Owning system password expired.", null, (short)28480, 13);
                    details.setErrLogMsg(callerMessage + ". This indicates the password expired on the owning system");
                    details.getRsfResultDetails().putAttribute("SAS rc", lastRc);
                    return null;
                }
                if (lastRc.equals("7151")) {
                    CredentialUtils.clearLocalCredentials();
                    RetainUtils.logErrorAndResult(details, message + ". Sending system password expired.  Local credential cleared.  Will retry", null, (short)28480, 14);
                    details.setErrLogMsg(callerMessage + ". This indicates the password expired on the sending system");
                    details.getRsfResultDetails().putAttribute("SAS rc", lastRc);
                    return null;
                }
                RetainUtils.logErrorAndResult(details, message, e, (short)28480, 12);
                Trace.trace(TRACE_MASKF, message + ". Will redrive on new connection or HMC.");
                details.setReasonCode(10);
                retryCount = 4;
            }
            catch (SasXmlException e) {
                RetainUtils.logErrorAndResult(details, "RetainUtils.getRetainToken: Error from SAS", e, (short)28480, 12);
                if (!tcpConnection.failSocket()) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    String exceptionTrace = stringWriter.toString();
                    details.setErrLogMsg("Strong authentication SAS XML Exception:\n" + exceptionTrace);
                    throw new IOException("Authentication error with get token: xml error");
                }
                retryCount = 0;
            }
            catch (SystemAuthenticationException e) {
                RetainUtils.logErrorAndResult(details, "RetainUtils.getRetainToken: System Authentication Exception", e, (short)28480, 10);
                if (!tcpConnection.failSocket()) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    String exceptionTrace = stringWriter.toString();
                    details.setErrLogMsg("Strong authentication System Authentication Exception:\n" + exceptionTrace);
                    throw new IOException("Authentication error with get token: System Authentication Exception");
                }
                retryCount = 0;
            }
            catch (IOException e) {
                RetainUtils.logError("Get token I/O exception", e, (short)28480);
                if (!tcpConnection.failSocket()) {
                    details.setReasonCode(11);
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    String exceptionTrace = stringWriter.toString();
                    details.setErrLogMsg("GetToken returned I/O Exception:\n" + exceptionTrace);
                    throw e;
                }
                retryCount = 0;
            }
        }
        if (!done) {
            details.setReasonCode(10);
            throw new IOException("Authentication error on get token");
        }
        if (token == null) {
            details.setErrLogMsg("Get token returned a null with no error indication");
            details.setReasonCode(10);
            throw new IOException("Authentication error on get token: no token");
        }
        if (!oneTest && BaseRemoteSupportFacility.testFlag.equals("BAD_TOKEN")) {
            Trace.trace(TRACE_MASKT, "<- RetainUtils::getRetainToken() testcase bad token");
            oneTest = true;
            return "GARBAGEGARBAGEGARBAGEGARBAGEGARBAGEGARBAGE";
        }
        if (!oneTest && BaseRemoteSupportFacility.testFlag.equals("SAS_SERVER_ERROR")) {
            Trace.trace(TRACE_MASKF, "RetainUtils.getRetainToken testcase sas server error");
            oneTest = true;
            IOException e = new IOException("Testcase initiated SAS Server Error");
            details.setReasonCode(11);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String exceptionTrace = stringWriter.toString();
            details.setErrLogMsg("GetToken returned I/O Exception:\n" + exceptionTrace);
            RetainUtils.logError("Get token I/O exception", e, (short)28480);
            throw e;
        }
        Trace.trace(TRACE_MASKT, "<- RetainUtils::getRetainToken()");
        return token;
    }

    private static void retryWait(int retryCount, String message) {
        RetainUtils.logInfo(message + ". getToken tries=" + retryCount + ". Will wait " + 1000 + " milliseconds.", null, (short)28480);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {}
    }

    private static void retryLongWait(int retryCount, String message) {
        RetainUtils.logInfo(message + ". getToken tries=" + retryCount + ". Will wait " + 60000 + " milliseconds.", null, (short)28480);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {}
    }

    public static int loginToRetain(BaseRsfRequestImpl request, Socket socket, BufferedInputStream bin, BufferedOutputStream bout, byte[] loginRecord, BaseRsfResultDetails details, boolean strongAuth) throws IOException {
        return RetainUtils.loginToRetain(request, socket, bin, bout, loginRecord, details, strongAuth, defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loginToRetain(BaseRsfRequestImpl request, Socket socket, BufferedInputStream bin, BufferedOutputStream bout, byte[] loginRecord, BaseRsfResultDetails details, boolean strongAuth, int timeout) throws IOException {
        byte[] reply;
        String initString;
        Trace.trace(TRACE_MASKT, "-> RetainUtils::loginToRETAIN() ");
        String machType = "";
        String machSerial = "";
        try {
            machType = new String(loginRecord, 12, 4, EBCDIC);
            machSerial = new String(loginRecord, 20, 7, EBCDIC);
        }
        catch (Exception e) {
            RetainUtils.logError("RetainUtils: Bad encoding getting machine info from login record", e, (short)28671);
            return 999;
        }
        Trace.trace(TRACE_MASKD, "RetainUtils.loginToRETAIN sending initial authorization");
        boolean vpn = false;
        try {
            vpn = request.getPath().isHighPerformancePath();
        }
        catch (Exception e) {
            RetainUtils.logError("RetainUtils.loginToRetain exception calling isHighPerformancePath", e, (short)28671);
        }
        AccountInfo acctInfo = request.getAccountInfo();
        if (vpn) {
            String prefix;
            String countryCode = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo().getSystemCountryCode();
            if (strongAuth) {
                Trace.trace(TRACE_MASKF, "RetainUtils::loginToRetain() using user string for authenticated vpn");
                prefix = saVpnPrefix;
            } else {
                Trace.trace(TRACE_MASKF, "RetainUtils::loginToRetain() using user string for legacy vpn");
                prefix = vpnPrefix;
            }
            initString = prefix + countryCode + "  " + machType + machSerial + "  " + vpnSuffix;
        } else {
            String prefix;
            if (strongAuth) {
                Trace.trace(TRACE_MASKF, "RetainUtils::loginToRetain() using user string for authenticated dial connection");
                prefix = saDialPrefix;
            } else {
                Trace.trace(TRACE_MASKF, "RetainUtils::loginToRetain() using user string for legacy dial connection");
                prefix = dialPrefix;
            }
            initString = prefix + RetainUtils.fixedLengthTextString(acctInfo.getAccount(), 8) + RetainUtils.fixedLengthTextString(acctInfo.getUserId(), 8) + dialSuffix;
        }
        Trace.trace(TRACE_MASKF, "RetainUtils user data (character):'" + initString + "'.");
        try {
            Trace.trace(TRACE_MASKD, "RetainUtils user data:" + RsfHexadecimal.buildHexadecimalString(initString.getBytes(EBCDIC)));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            RetainUtils.send(bout, initString, true);
        }
        catch (IOException i) {
            RetainUtils.logErrorAndResult(details, "RetainUtils.loginToRetain: I/O error trying to send initial authorization", i, (short)28592, 1);
            Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN() ");
            throw i;
        }
        String loginResponse = "";
        Trace.trace(TRACE_MASKF, "RetainUtils.loginToRETAIN receiving initial authorization login response");
        Object object = lock;
        synchronized (object) {
            try {
                reply = RetainUtils.receive(socket, bin, timeout);
                if (reply == null) {
                    RetainUtils.logErrorAndResult(details, "RetainUtils.loginToRetain: I/O error trying to receive initial authorization reply", null, (short)28592, 2);
                    Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
                    throw new IOException("Receive error");
                }
                loginResponse = RsfHexadecimal.buildHexadecimalString(reply, 0, reply.length);
            }
            catch (IOException i) {
                RetainUtils.logErrorAndResult(details, "RetainUtils.loginToRetain: I/O error trying to receive initial authorization reply", i, (short)28592, 2);
                Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
                throw i;
            }
        }
        if (!loginResponse.equals("00000000")) {
            Trace.trace(TRACE_MASKF, "RetainUtils.loginToRETAIN: Error in initial login: " + loginResponse);
            try {
                String message = new String(reply, EBCDIC);
                Trace.trace(TRACE_MASKD, "RetainUtils.loginToRETAIN: Initial login Data: " + message);
            }
            catch (Exception e) {
                RetainUtils.logErrorAndResult(details, "RetainUtils: loginToRetain: Bad encoding", e, (short)28671, 7);
                return 999;
            }
            RetainUtils.logErrorAndResult(details, "RetainUtils.loginToRetain: Initial authorization error", null, (short)28530, 3);
            Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
            return 99;
        }
        Trace.trace(TRACE_MASKD, "RetainUtils:: loginToRETAIN() Initial OK authorization response received");
        Trace.trace(TRACE_MASKD, "RetainUtils Login data:" + RsfHexadecimal.buildHexadecimalString(loginRecord));
        Trace.trace(TRACE_MASKF, "RetainUtils.loginToRETAIN Sending login record to RETAIN");
        try {
            RetainUtils.sendBytes(bout, loginRecord, loginRecord.length, true);
        }
        catch (IOException i) {
            RetainUtils.logErrorAndResult(details, "RetainUtils.loginToRetain: I/O error trying to send login record", i, (short)28592, 1);
            Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN() error sending login record");
            throw i;
        }
        Object object2 = lock;
        synchronized (object2) {
            try {
                Trace.trace(TRACE_MASKF, "RetainUtils.loginToRETAIN get response to login record");
                reply = RetainUtils.receive(socket, bin, timeout);
                if (reply == null) {
                    RetainUtils.logErrorAndResult(details, "RetainUtils.loginToRetain: no reply from RETAIN login", null, (short)28592, 2);
                    Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN() login record reply=null");
                    throw new IOException("Receive error");
                }
                loginResponse = RsfHexadecimal.buildHexadecimalString(reply, 0, reply.length);
            }
            catch (IOException i) {
                RetainUtils.logErrorAndResult(details, "RetainUtils.loginToRetain: I/O error trying to receive login response", i, (short)28592, 2);
                Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
                throw i;
            }
        }
        if (loginResponse.equals("00000159")) {
            String msg = "RetainUtils: Machine not registered. Type: " + machType + " Serial: " + machSerial;
            RetainUtils.logInfo(msg, null, (short)28530);
            details.setReasonCode(5);
            details.setErrLogMsg("Retain returned machine not registered. Type: " + machType + " Serial: " + machSerial);
            Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
            return 999;
        }
        if (loginResponse.equals("00000110")) {
            String msg = "RetainUtils: Machine type not recognized. Type: " + machType;
            RetainUtils.logError(msg, null, (short)28530);
            details.setReasonCode(7);
            details.setErrLogMsg("Retain returned machine type not recognized. Type: " + machType);
            Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
            return 999;
        }
        if (loginResponse.equals("00000000")) {
            Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
            return 0;
        }
        if (loginResponse.equals("00000025")) {
            String msg = "Retain login returned MTMS token mismatch";
            RetainUtils.logErrorAndResult(details, msg, null, (short)28480, 13);
            Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
            return 999;
        }
        if (loginResponse.equals("00000023")) {
            String msg = "Retain login returned invalid token";
            RetainUtils.logErrorAndResult(details, msg, null, (short)28480, 10);
            Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
            return 999;
        }
        if (loginResponse.equals("00000024")) {
            String msg = "Retain login returned Proxy can't communicate with authentication server";
            RetainUtils.logErrorAndResult(details, msg, null, (short)28480, 11);
            Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
            return 999;
        }
        try {
            String message = new String(reply, EBCDIC);
            Trace.trace(TRACE_MASKF, "RetainUtils.loginToRetain login message: " + message + " (hex):" + loginResponse);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "RetainUtils.loginToRETAIN: Bad encoding");
            Trace.trace(TRACE_MASKF, e);
            return 99;
        }
        RetainUtils.logErrorAndResult(details, "Retain Utils: Error returned from RETAIN login: " + loginResponse, null, (short)28530, 3);
        Trace.trace(TRACE_MASKT, "<- RetainUtils::loginToRETAIN()");
        return 99;
    }

    private static void logRetainError(BaseRsfResultDetails details, String errorMsg) {
        RetainUtils.logErrorAndResult(details, errorMsg, null, (short)28530, 3);
    }

    private static void logErrorAndResult(BaseRsfResultDetails details, String errorMsg, Throwable t, short errorId, int resultError) {
        details.setReasonCode(resultError);
        RetainUtils.logError(errorMsg, t, errorId);
    }

    private static void logInfoAndResult(BaseRsfResultDetails details, String errorMsg, Throwable t, short errorId, int resultError) {
        FrameworkLog errLog;
        details.setReasonCode(resultError);
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private static void logError(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private static void logInfo(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    public static void sendBytes(BufferedOutputStream bout, byte[] data, int length, boolean flush) throws IOException {
        Trace.trace(TRACE_MASKD, "-> RetainUtils::sendBytes() " + length + " bytes");
        int sendlength = length;
        if (length > data.length) {
            sendlength = data.length;
        }
        bout.write(data, 0, sendlength);
        if (flush) {
            bout.flush();
        }
        Trace.trace(TRACE_MASKD, "<- RetainUtils::sendBytes()");
    }

    public static void send(BufferedOutputStream bout, String data, boolean flush) throws IOException {
        Trace.trace(TRACE_MASKD, "-> RetainUtils::send() " + data.length() + " chars");
        byte[] inStream = data.getBytes(EBCDIC);
        bout.write(inStream, 0, inStream.length);
        bout.flush();
        Trace.trace(TRACE_MASKD, "<- RetainUtils::send()");
    }

    public static byte[] receive(Socket connection, BufferedInputStream bin, int timeout) throws IOException {
        Trace.trace(TRACE_MASKT, "-> RetainUtils::receive()");
        if (connection.getSoTimeout() == 0) {
            connection.setSoTimeout(timeout);
        }
        Trace.trace(TRACE_MASKD, "RetainUtils::receive() with new timeout " + connection.getSoTimeout());
        byte[] lbuffer = new byte[2];
        byte[] data = null;
        int andByte = 127;
        int blength = 0;
        int length = 0;
        try {
            blength = bin.read(lbuffer, 0, lbuffer.length);
            Trace.trace(TRACE_MASKF, "RetainUtils: receive: length bytes=" + RsfHexadecimal.buildHexadecimalString(lbuffer, 0, blength));
            length = lbuffer[1] < 0 ? lbuffer[0] * 256 + (lbuffer[1] & andByte + 128) : lbuffer[0] * 256 + lbuffer[1];
            Trace.trace(TRACE_MASKD, "RetainUtils.receive: length received=" + length);
            if (blength < 2 || length <= 2) {
                Trace.trace(TRACE_MASKF, "RetainUtils: receive: invalid length=" + length + "hexadecimal data:" + RsfHexadecimal.buildHexadecimalString(lbuffer, 0, blength));
                Trace.trace(TRACE_MASKT, "<- RetainUtils::receive()");
                return data;
            }
            int datalength = length - 2;
            int amountRead = 0;
            int remainder = datalength;
            data = new byte[datalength];
            int i = 0;
            while (i < 60) {
                blength = bin.read(data, amountRead, remainder);
                amountRead += blength;
                if (blength == remainder) {
                    Trace.trace(TRACE_MASKD, "RetainUtils.receive: Amount of data equals amount promised: " + remainder);
                    break;
                }
                if (blength < remainder) {
                    Trace.trace(TRACE_MASKF, "RetainUtils.receive: Amount of data invalid- Promised " + remainder + " found " + blength + ". Will wait for " + 1000 + " milliseconds for more to become available");
                    remainder -= blength;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                } else {
                    RetainUtils.logError("RetainUtils.receive: Received more data than requested", null, (short)28671);
                    break;
                }
                ++i;
            }
            int printAmount = amountRead;
            if (amountRead > 24) {
                printAmount = 24;
            }
            Trace.trace(TRACE_MASKD, "Num Bytes received (not including length): " + amountRead + "First 24 bytes of Data:" + RsfHexadecimal.buildHexadecimalString(data, 0, printAmount));
        }
        catch (InterruptedIOException e) {
            Trace.trace(TRACE_MASKF, "<- RetainUtils.receive timeout on receive");
            throw e;
        }
        Trace.trace(TRACE_MASKT, "<- RetainUtils::receive()");
        return data;
    }

    public static void appendToFile(File writeFile, byte[] data, int startIndex, int length) throws IOException {
        Trace.trace(TRACE_MASKT, "-> RetainUtils::appendToFile() '" + writeFile + "' " + length + " bytes");
        RandomAccessFile raFile = new RandomAccessFile(writeFile, "rw");
        long endFile = raFile.length();
        raFile.seek(endFile);
        Trace.trace(TRACE_MASKD, "RetainUtils.writeFile at " + raFile.getFilePointer() + " in file.");
        raFile.write(data, startIndex, length);
        raFile.close();
        Trace.trace(TRACE_MASKT, "<- RetainUtils::appendToFile()");
    }

    public static boolean moveNewFile(BaseRsfRequestImpl request, File currentFile, String newFilename, String newFilePath) {
        Trace.trace(TRACE_MASKT, "-> RetainUtils::moveNewFile()");
        if (request.isLocalRequest()) {
            if (newFilePath == null) {
                try {
                    newFilePath = BaseFileControl.getFilePath(newFilename);
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "RetainUtils.moveNewFile: can't find local file path for " + newFilename);
                    newFilePath = "";
                }
            }
            String filePath = newFilePath + newFilename;
            Trace.trace(TRACE_MASKF, "RetainUtils.moveNewFile: about to rename temp file to " + filePath + " for local request");
            File mcFile = new File(filePath);
            if (!currentFile.renameTo(mcFile)) {
                Trace.trace(TRACE_MASKF, "RetainUtils.moveNewFile about to copy temp file, " + currentFile + " to " + filePath + " for local request");
                try {
                    FileUtilities.copy(currentFile, mcFile);
                    currentFile.delete();
                }
                catch (Exception e) {
                    RetainUtils.logError("RetainUtils.moveNewFile: Unable to copy file to staging directory " + filePath, e, (short)28461);
                    return false;
                }
            }
        } else {
            String filePath;
            boolean fullyQualifiedRemotePath = true;
            if (newFilePath == null) {
                fullyQualifiedRemotePath = false;
                filePath = newFilename;
            } else {
                filePath = newFilePath + newFilename;
            }
            String tempFileName = currentFile.getAbsolutePath();
            Trace.trace(TRACE_MASKF, "RetainUtils.moveNewFile about to transfer temp file " + tempFileName + " for remote request to remote " + filePath);
            if (!request.putFile(tempFileName, filePath, fullyQualifiedRemotePath)) {
                Trace.trace(TRACE_MASKF, "RetainUtils.moveNewFile: error transfering file ");
                currentFile.delete();
                Trace.trace(TRACE_MASKT, "<- RetainUtils.moveNewFile putFile failure");
                return false;
            }
            currentFile.delete();
        }
        Trace.trace(TRACE_MASKT, "<- RetainUtils::moveNewFile()");
        return true;
    }

    public static String fixedLengthTextString(String data, int length) {
        return RetainUtils.fixedLengthString(data, length, true, ' ');
    }

    public static String fixedLengthString(String data, int length, boolean right, char pad) {
        if (data == null) {
            data = new String("");
        }
        int currentLength = data.length();
        int diff = 0;
        diff = currentLength - length;
        if (diff < 0) {
            int posDiff = Math.abs(diff);
            StringBuffer result = right ? new StringBuffer(data) : new StringBuffer();
            int i = 0;
            while (i < posDiff) {
                result.append(pad);
                ++i;
            }
            if (!right) {
                result.append(data);
            }
            return result.toString();
        }
        if (diff > 0) {
            if (right) {
                return data.substring(0, length);
            }
            return data.substring(diff);
        }
        return data;
    }

    public static byte[] calcLength(int length) {
        byte[] byteLength = new byte[]{(byte)((length + 2) / 256), (byte)((length + 2) % 256)};
        Trace.trace(TRACE_MASKD, "RetainUtils: Send length=" + RsfHexadecimal.buildHexadecimalString(byteLength));
        return byteLength;
    }

    public static int findXmlLength(byte[] data) {
        Trace.trace(TRACE_MASKD, "->RetainUtils: findXmlLength: endBytes=" + RsfHexadecimal.buildHexadecimalString(endBytes) + " lcEndBytes=" + RsfHexadecimal.buildHexadecimalString(lcEndBytes));
        int endXml = 0;
        int matchLength = Math.min(endBytes.length, lcEndBytes.length);
        int i = 0;
        while (i <= data.length - matchLength) {
            int j = 0;
            while (j < matchLength) {
                if (data[i + j] != endBytes[j] && data[i + j] != lcEndBytes[j]) break;
                if (j == matchLength - 1) {
                    endXml = i + j + 1;
                }
                ++j;
            }
            ++i;
        }
        Trace.trace(TRACE_MASKD, "RetainUtils.findXmlLength: endXml=" + endXml);
        if (endXml == 0) {
            endXml = data.length;
            if (data.length > 11) {
                try {
                    String endString = new String(data, data.length - 6, 6, EBCDIC);
                    if (endString.equalsIgnoreCase("</CID>")) {
                        Trace.trace(TRACE_MASKT, "<- RetainUtils::findXmlLength()");
                        return endXml;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            Trace.trace(TRACE_MASKF, "RetainUtils.findXmlLength: Couldn't find end of Xml header");
        }
        Trace.trace(TRACE_MASKT, "<- RetainUtils::findXmlLength()");
        return endXml;
    }

    static {
        lock = new Object();
        defaultTimeout = 300000;
        EBCDIC = "Cp500";
        oneTest = false;
        endBytes = new byte[]{0};
        lcEndBytes = new byte[]{0};
        try {
            tempPath = new File(BaseFileControl.getFilePath("tmp"));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "RetainUtils: static block - Unable to get temp file path");
            new FrameworkLog(logInfo, 28451, e).log(infoLog);
        }
        try {
            endBytes = "</AL>".getBytes(EBCDIC);
            lcEndBytes = "</al>".getBytes(EBCDIC);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "RetainUtils: static block - Unable to build endBytes");
            new FrameworkLog(logInfo, 28671, e).log(infoLog);
        }
    }
}

